/* v1.1
 *
 * sensors.h:  Sensor module header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

/* display_ship_data control words */
#define DSD_NEW                 0
#define DSD_UPDATE              1
#define DSD_ROUTINE             2
#define DSD_DETAILED            3

#define HubRange(pos)   (range_t) sqrt((double) pos.x*pos.x + \
				       (double) pos.y*pos.y + \
				       (double) pos.z*pos.z)

extern void snsBuildDistanceTables(int);
extern void snsFreeDistanceTables(int);
extern void snsCheckSensors(int);
extern CONTACT *snsFindContact(TAG *, TAG *);
extern CONTACT *snsFindContactByNumber(TAG *, int);
extern void snsRemoveContact(TAG *, TAG *, int);
extern void snsSenseObject(TAG *, TAG *);
extern void snsListContacts(char *, CONTACT *, int, int);
extern void snsScan(TAG *, void *, int);
extern void snsDisplaySensorInfo(TAG *, CONTACT *, dbref, int);
extern void snsDisplayContacts(TAG *, void *, int, int);
extern void snsDisplayShortContacts(TAG *, void *, int, int);
extern void snsContactString(TAG *, CONTACT *, char *buff,
			     struct timeval *now);
extern void snsAddObject(TAG *, int);
extern void snsDelObject(TAG *, int);

#ifdef ENABLE_DEBUGGING
extern void snsSanityCheck(int);
#endif
