/* v0.9
 *
 * varray.h:  Virtual Array (VArray) Module Header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.
 */

#include "hashtab.h"

/* Constants and enumerators */

#define VA_STRINGCHUNK 100	/* The size that the string space
				   grows each time it is filled */

typedef enum{VA_STRING, VA_NUMBER, VA_FORMULA} VArrayType;

/* Type definitions */

typedef struct varray {
     VArrayType type;
     int nitems;
     char **index;
     int size;
     int mark;
     char *data;
} VArray;

typedef struct varray_idxentry {
     char *name;
     int index;
     int flags;
     int dbattr;
     struct varray_idxentry *next;
} VAIDXENTRY;

typedef struct varray_index {
     VAIDXENTRY *root;
     HNODE *htab;
     int maxindex;

     /* Name string block for user-defined index entries. */
     int strsize;
     int strmark;
     char *strings;
} VArrayIndex;

/* Index flags */

#define VA_REQUIRED 0x00000001	/* bit 0 */
#define VA_OPTMASK  0x0000000e	/* bits 1-3 */

/* Options --  bits that select options for particular VArray types. */

#define Option(x) (x << 1)

/* Number options */
#define VA_TYPE_INT Option(1)
#define VA_TYPE_FLOAT Option(2)

/* String options */
#define VA_NOPARSE Option(1)
#define VA_FASTPARSE Option(2)
#define VA_FULLPARSE Option(3)

extern VArrayIndex *vaAllocateIndex(void);
extern VArray *vaAllocateVArray(int, int, int);
extern void vaFreeVArray(VArray *);
extern void vaFreeIndex(VArrayIndex *vidx);
extern VArrayIndex *vaCreateIndexFromTable(VAIDXENTRY *);
extern void vaAddIndexEntry(VArrayIndex *, char *, int);
extern int vaGetMaxIndex(VArrayIndex *);
extern int vaGetIndex(VArrayIndex *, const char *);
extern int vaSetItem(VArray *, int, const void *);
extern float vaGetItemAsFloat(VArray *, int);
extern int vaGetItemAsInt(VArray *, int);
extern char *vaGetItem(VArray *, int);

/* Some extra macros for fun. */
#define vaAllocateVArrayAsNumber(num) vaAllocateVArray(VA_NUMBER, num * 4, num)
