/* v0.9
 *
 * space.h:  General space definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#define FALSE 0
#define TRUE  1

#ifndef PI
#define PI 3.1415926535897
#endif

#define FRAND ((float)( rand() & 65535 ) / 65536.0)
#define Max(x,y)	(x > y ? x : y)
#define Min(x,y)	(x < y ? x : y)
#define Sign(x)		(x >= 0 ? 1 : -1)

/* Size of attribute buffer */
#define LARGE_BUF_SIZE  16000
#define SMALL_BUF_SIZE  400

#define MAX_TORPS               6
#define MAX_GUNS                6
#define MAX_COMM_CHANNELS       6
#define MAX_TEAMS               6
#define NUM_SYSTEMS		26

#define INFO_VERBOSE            0
#define INFO_TERSE              1

#define SS_SCAN   		0
#define SS_REPORT 		1

/* shield indices */
#define NUM_SHIELDS	      	6

#define FORE_SHIELD             0
#define AFT_SHIELD              1
#define PORT_SHIELD             2
#define STARBOARD_SHIELD        3
#define DORSAL_SHIELD		4
#define VENTRAL_SHIELD		5

/* miscellaneous configurable paramaters */
#define DOCK_RANGE		5	/* how close to starbase must you be */
#define BATTERY_BLEED		0.97	/* % of btty lost per turn online */
#define SHLD_READY_BLEED	0.99	/* loss on ready shields */
#define SHLD_UP_BLEED		0.90	/* loss on raised shields */

/*
 * Sensor penalties for cloaked ships, and uncloaked ships at quarter penalty
 */

#define GUN_ONLINE_PENALTY      0.05
#define TORP_CHARGING_PENALTY   0.20
#define TORP_ARMED_PENALTY      0.40 

/* ship text field sizes */
#define NAME_LEN		32
#define CLASS_LEN		32
#define TYPE_LEN		32
#define OWNER_LEN		32
#define GUN_LEN                 32
#define TORP_LEN                32

#ifdef ENABLE_LONG_LONG_COORDS

typedef long long range_t;
typedef long long coord_t;

#define RANGEF "%Ld"
#define COORDF "%Ld"
#define RANGEF_NP "%Ld"
#define COORDF_NP "%Ld"
#define RANGEI(x) atoll(x)
#define RANGEA(x) llabs(x)
#define MAX_RANGE 0x7fffffffffffffff

#else
#ifdef ENABLE_FLOATS

typedef double range_t;
typedef double coord_t;

/* Constants for formatting position data. _NP signifies 'no padding' */
#define RANGEF "% 14.3f"
#define COORDF "% 14.3f"
#define RANGEF_NP "%14.3f"
#define COORDF_NP "%14.3f"
#define RANGEI(x) atof(x)
#define RANGEA(x) fabs(x)
#define MAX_RANGE DBL_MAX
#define FULL_IMPULSE_DISTANCE 1.0

#else

typedef int		range_t;
typedef int		coord_t;

#define RANGEF "%d"
#define COORDF "%d"
#define RANGEF_NP "%d"
#define COORDF_NP "%d"
#define RANGEI(x) atoi(x)
#define RANGEA(x) abs(x)
#define MAX_RANGE 0x7fffffff

#endif
#endif

/* cartesian coordinate struct */
typedef struct xyz_coord {
	range_t	x;
	range_t	y;
	range_t	z;
} XYZ;

/* spherical coordinate struct */
typedef struct sph_coord {
	float bearing;
	float elevation;
	range_t range;
} SPH;

/* Global constants */
#define MAX_SPACE_NAME_LEN	32

typedef struct tag_entry TAG;
typedef struct timer_entry TIMER;

/* space event timer struct */
struct timer_entry {
    TIMER *next;           /* Next timer in the list */
    TAG *object;           /* Object this timer is for */
    unsigned int flags;    /* Timer control flags */
    int expires;           /* Turn ID the timer expires at */
    int interval;          /* Interval between events */
    int events;            /* Number of events */
    int count;             /* Number of times event has been triggered */
    char *id;              /* Identification string, if specified */
};

#define TIMER_CONTINUOUS    0x0001
#define TIMER_REMOVED       0x0002

typedef struct space_info_struct {
    char   name[MAX_SPACE_NAME_LEN];
    int    flags;          /* Behaviour flags. See below for SPACE_* */
    TAG    *list;          /* Linked list of objects in this space */
    TAG    *tail;          /* Last object in list */
    TAG    *dist;          /* Range sorted object list */
    TAG    *huge;          /* Huge object range sorted list */
    TIMER  *timers;        /* Linked list of timers for this space */
    int    cycle;          /* Monotonic update cycle counter */
} SPACEINFO;

#define SPACE_LOGGED    0x0001
#define SPACE_LOCKED    0x0002
#define SPACE_ACTIVE    0x0004

#ifdef ENABLE_TURN_BASED
#define SPACE_DO_TURN   0x0008
#endif

extern SPACEINFO space_info[];

extern const char *system_names[];
extern int move_turn_id;
extern void add_timer(TAG*, int, int, int, const char *);
extern void del_timer(TAG *object, const char *id);
