/* v0.9
 *
 * scm.h:  Shield Class Module header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

#ifndef __SCM_H__
#define __SCM_H__

#include "../varray.h"

#define SCM_MAX_LAYERS          4    /* Max number of layers of shields */
#define SCM_MAX_SHIELDS         8    /* Max number of shields per geometry */
#define SCM_MAX_NAME_LEN        80   /* Max length of the layer name */

typedef struct scm_interface    SCM_INTERFACE;
typedef struct sc_geom          SCGEOM;
typedef struct sc_layer         SCLAYER;

typedef int (*scmInitModule_t)(void);
typedef int (*scmFreeModule_t)(void);
typedef int (*scmLoadLayer_t)(dbref, SCLAYER*, const char *);

struct scm_interface {
    char            scmName[SCM_MAX_NAME_LEN];  /* Unique module identifier */
    int             scmNameLen;                 /* Length of name */
    scmInitModule_t scmInitModule;
    scmFreeModule_t scmFreeModule;
    scmLoadLayer_t  scmLoadLayer;
};

struct sc_geom {
    int  shields;                               /* Number of shields */
    int  layout[SCM_MAX_SHIELDS][7];            /* Geometry definition */
};

struct sc_layer {
    const char    name[SCM_MAX_NAME_LEN];       /* Name the user sees     */
    SCM_INTERFACE *properties;                  /* Plugin for this layer  */
    VArray        *storage;                     /* Storage for plugin     */
    SCGEOM        geometry;                     /* Geometry of this layer */
    int           attrib;                       /* Data Attribute         */
};

#ifdef DEBUG
extern int scAssertValid(SCDEF *);
#define SCASSERT(x) if(scAssertValid(x) == 0) return "OOPS: Invalid shield class pointer.";
#else
#define SCASSERT(x)
#endif

extern void scmInitModules(void);
extern const char *scmListRegisteredModules(void);
extern int scmLoadLayer(dbref, SCLAYER*, const char *);

#endif
