/* v0.9
 *
 * platform.h:  MUD platform-specific macros and definitions.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */ 

#define SPACE
#define PLATFORM_H

#ifndef NULL
#define NULL 0
#endif

#ifdef MUSH
#define lint      /* Cure the annoying warning messages */
#endif

/*
 * Include headers from Mux / Mush / Penn as appropriate. The server choice
 * is made in spaceconf.h
 */

#if defined(MUX) || defined(MUSH)

#include <copyright.h>
#include <autoconf.h>
#include <mudconf.h>
#include <config.h>
#include <db.h>
#include <interface.h>
#include <externs.h>
#include <match.h>
#include <command.h>
#include <alloc.h>
#include <attrs.h>
#include <functions.h>
#include <flags.h>

#endif

#ifdef PENN

/*
 * Probably really need a few more than this here...seems to work though.
 */
#include <externs.h>
#include <attrib.h>
#include <parse.h>
#include <dbdefs.h>
#endif

/*
 * This is the prototype for MU* functions.
 */

#ifdef MUX 
#define MUDFUNCTION(x)     \
void x(buff, bufc, player, cause, fargs, nfargs, cargs, ncargs) \
        char *buff, **bufc; \
        dbref player, cause; \
        char *fargs[], *cargs[]; \
        int nfargs, ncargs;

typedef struct
{
    char *buff;
    char **bufc;
} MUDPARAM;

#endif

#ifdef MUSH
#define MUDFUNCTION(x)     \
void x(buff, player, cause, fargs, nfargs, cargs, ncargs) \
        char *buff; \
        dbref player, cause; \
        char *fargs[], *cargs[]; \
        int nfargs, ncargs;

typedef struct
{
    char *buff;
} MUDPARAM;
#endif

#ifdef PENN

#define MUDFUNCTION(x)     \
void x(buff, bufc, nargs, args, executor, caller, enactor, called_as, \
        pe_info) \
        char *buff; \
        char **bufc; \
        int nargs; \
        char *args[]; \
        dbref executor; \
        dbref caller; \
        dbref enactor; \
        const char *called_as; \
        PE_Info *pe_info;

typedef struct
{
    char *buff;
    char **bufc;
    PE_Info *pe_info;
} MUDPARAM;

#endif
