/* v0.9
 *
 * object.h:  Object module header.
 *
 * This program is free software and may be freely redistributed as
 * specified in the GNU General Public License.  Please see the file
 * 'COPYING' for details.   
 */

typedef struct contact_entry CONTACT;
typedef struct ship_entry SHIP;

struct contact_entry {
    
    CONTACT *next;
    TAG *listref;
    int contact_number;         /* The contact number. Local per object */
    int turns_of_contact;
    int turns_since_last_contact;
    int info_level;
    XYZ last_pos;
    int watcher;
    int inside_critical;
    int updated;                /* Turn ID when last updated */
    
};

struct tag_entry {

    char name[NAME_LEN];
    dbref data_object;
    int space;
    unsigned int tagflags;
    XYZ pos;
    SPH heading;
    SPH heading_adj;
    float roll;                 /* Roll position */
    float roll_adj;             /* Adjustment to roll position */
    float v_move[3];            /* Movement unit vector */
    int turnID;                 /* Turn ID of last rotation */
    int moveID;                 /* Turn ID of last movement */
    
    float speed;
    float size;
    
    range_t sensor_range;
    range_t transporter_range;
    range_t critical_range;
    char range_name[NAME_LEN];
    float range_factor;
    
    float cloak_effect;
    CONTACT *pending_lock;
    CONTACT *locked_on;
    SHIP *shipdata;
    CONTACT *contact_list;
    int contact_offset;         /* Used to normalize contact numbers */
    
    TAG *tractor_source;
    TAG *next;
    
    range_t range;		/* Range of object from 0,0,0 */
    TAG *huge_prev;		/* Huge objects linked list */
    TAG *huge_next;		/* Huge objects linked list */
    TAG *range_prev;		/* Normal objects linked list */
    TAG *range_next;		/* Normal objects linked list */
};

#define TYPE_SHIP	0x00000001	/* Object is a ship */
#define TYPE_PLANET	0x00000002	/* Object is a planet */
#define CAN_MOVE	0x00000004
#define MANUAL_POS 	0x00000008
#define MANUAL_DIR 	0x00000010
#define EVENT_DRIVEN	0x00000020	/* Object is checked for events */
#define CAN_SENSE	0x00000040
#define CAN_BEAM_TO	0x00000080	/* Transporters can lock on object */
#define BEAMABLE	0x00000100	/* Object can be beamed */
#define ATTACKABLE	0x00000200	/* Object can be attacked */
#define HUGE_OBJ	0x00000400	/* Treat as a huge object w/ sensors */
#define OMNISCIENT	0x00000800	/* Object has infinite sensor range */
#define NEARSIGHTED	0x00001000	/* Object can see all within range */
#define INVISIBLE	0x00002000	/* Object is invisible */
#define HAZY		0x00004000	/* Object is difficult to see */
#define CATARACTS	0x00008000	/* Object has difficulty seeing */
#define CLOAKED		0x00010000	/* Object is cloaked */
#define CAN_BEAM_FROM	0x00020000	/* Things can be beamed from object */
#define TRACTORABLE     0x00040000      /* Object can be tractored */

#define CanMove(x)		((x->tagflags & CAN_MOVE) != 0)
#define CanSense(x)		((x->tagflags & CAN_SENSE) != 0)
#define Ship(x)			((x->tagflags & TYPE_SHIP) != 0)
#define Planet(x)		((x->tagflags & TYPE_PLANET) != 0)
#define ManualPosition(x)	((x->tagflags & MANUAL_POS) != 0)
#define ManualDirection(x)	((x->tagflags & MANUAL_DIR) != 0)
#define Beamable(x)		((x->tagflags & BEAMABLE) != 0)
#define CanBeamTo(x)		((x->tagflags & CAN_BEAM_TO) != 0)
#define CanBeamFrom(x)		((x->tagflags & CAN_BEAM_FROM) != 0)
#define Attackable(x)		((x->tagflags & ATTACKABLE) != 0)
#define Huge(x)			((x->tagflags & HUGE_OBJ) != 0)
#define Omniscient(x)		((x->tagflags & OMNISCIENT) != 0)
#define Nearsighted(x) 		((x->tagflags & NEARSIGHTED) != 0)
#define Invisible(x) 		((x->tagflags & INVISIBLE) != 0)
#define Hazy(x)			((x->tagflags & HAZY) != 0)
#define Cloaked(x)		((x->tagflags & CLOAKED) != 0)
#define HasCataracts(x) 	((x->tagflags & CATARACTS) != 0)
#define EventDriven(x)		((x->tagflags & EVENT_DRIVEN) != 0)
#define Tractorable(x)          ((x->tagflags & TRACTORABLE) != 0)

#define REMOVED		0x80000000 /* Object is to be removed from space */
#define Removed(x)	((x->tagflags & REMOVED) != 0)

#include "ship.h"

extern void objInitSpace(void);
extern void objAddObject(dbref);
extern void objRemoveObject(TAG *);
extern void objUpdateState(TAG *, dbref);
extern void objDisplaySpecs(TAG *, dbref, int);
extern void objSetObjectFlag(TAG *, dbref, int, char *);
extern void objSetShipFlag(TAG *, dbref, int, char *);
extern int objHasObjectFlag(const TAG *, dbref, const char *);
extern int objHasShipFlag(const TAG *, dbref, const char *);
extern int objHasConsoleFlag(const TAG *, dbref, int, const char *);
extern void objList(dbref, int, int, int);
extern TAG *objFindObject(dbref target);
extern void objFreeMarkedObjects(int space);
extern int objSystemNameToInt(const TAG *object, char *system);
extern const char *objSystemIntToName(const TAG *object, int system);
